/***************************************************************
 * Ruch małego ciala (punktu materialnego) w polu  
 * grawitacyjnym Ziemi (sferycznie symetrycznym) z wyświetlaniem  
 * ************************************************************/
var Vstart = 7.9 * 1000; //prędkość startowa w m/s
var Kstart = 0; //kąt startu w stopniach (poziomo 0))
var WysPocz = 100 * 1000; //wysokość startu nad powierzchnią w m

var M = 5.9745 * pow(10, 24); //masa planety w kg (Ziemia)
var R = 6378 * 1000; //promień planety w m (Ziemia)
//Tego nie należy zmieniać chyba, że chcemy zmienić Wszechświat
var G = 6.673 * pow(10, -11); //stała grawitacji

//Gdzie i jak wielka będzie rysowana planeta
var metrNaPiksel = 100000;
var srednicaZiemiwPiks = 2 * R / metrNaPiksel;
var Xcentrum = 200;
var Ycentrum = 200;

//przesunięcie wsp. aby (0,0) było "centrum" obrazka
translate(Xcentrum, Ycentrum);
background(0, 0, 0); //czarne tło rysowane tylko raz
//rysowanie planety
fill(69, 161, 143); //kolor planety
noStroke(); //bez obwódki
ellipse(0, 0, srednicaZiemiwPiks, srednicaZiemiwPiks);

//Współrzędne przy założeniu że (0, 0) jest centrum rysunku
var x = R + WysPocz; //współrzędna x satelity w metrach
var y = 0; //współrzędna y satelity w metrach
var r = sqrt(pow(x,2)+pow(y,2)); //odległość od śr. planety
//składowe prędkości satelity
var Vx = Vstart * cos(90-Kstart);
var Vy = Vstart * sin(90-Kstart);

// czas start
    var t=0;
    var dt=10;
        r = sqrt(pow(x,2)+pow(y,2));
        var Ar = -1 *G * M / pow(r, 2); //prawo pow. ciążenia
        var Ax = Ar * x/r; //skł. x przyspieszenia
        var Ay = Ar * y/r; //skł. y przyspieszenia
// prędkość w połowie przedziału czasowego 
        Vx = Vx + Ax * dt/2;
        Vy = Vy + Ay * dt/2;

var draw = function() {//funkcja draw - pętla rysowania w kółko
    //symulacja ruchu ma być kontynuowana tylko wtedy gdy
    //satelita jest nad powierzchnią planety
      t = t + dt; //nowy czas dla następnego kroku
      if (r >= R) { //obliczanie nowych współrzędnych x i y
        x = x + Vx * dt;
        y = y + Vy * dt;
      //przyspieszenie grawitacyjne w tym punkcie
      //minus oznacza kierunek do środka planety 
        r = sqrt(pow(x,2)+pow(y,2));
        Ar = -1 *G * M / pow(r, 2);
        Ax = Ar * x/r; //skł. x przyspieszenia
        Ay = Ar * y/r; //skł. y przyspieszenia
      //nowa prędkość wynikająca z przyspieszenia 
      //i wybranego kroku czasowego
        Vx = Vx + Ax * dt;
        Vy = Vy + Ay * dt;
        var V = sqrt(pow(Vx,2)+pow(Vy,2));
      //rysuj piksel w obl. punkcie (-1 bo y rys. w dół)
        stroke(185, 201, 222); //kolor punktów na torze satelity
        point(x/metrNaPiksel, -1 * y/metrNaPiksel);
      //wypisywanie wartości
         noStroke(); //wymazywanie poprzednich wartości
         fill(0, 0, 0); //czarnym kolorem
         rect(-140,-198, 70, 60);
       fill(171, 171, 144); //kolor napisów
       textSize(18); //rozmiar napisów
        text("r(km)=",-195,-180);
       text(round(r/1000),-140,-180); //odległość w km
        text("v(km/s)=",-200,-160); 
       text(round(V)/1000,-130,-160); //prędkość w km/s
        text("a(m/s^2)=",-200,-140); 
       text(-1*Ar,-120,-140); //przyspieszenie w m/s^2
        }    
    };